# Simple Netaid Daemon

snetaid is an UNIX configuration daemon for simple-netaid, whose mission is to 
automatically connect the ethernet device when a cable is plugged in, or in the 
second place, the wireless device if some of the available active wifis has been 
installed in your system previously. It uses Debian's native ifupdown 
program for that.


## Installation

Use the [APT](https://wiki.debian.org/Apt) package manager to install snetaid.

```bash
apt-get install snetaid
```

That done, the configuration of the daemon will be defined in /etc/simple-netaid/snetaid.conf. 
This file is sourced by the init script and used to start snetaid with appropriate arguments. 
Edit the content for configuration changes. Default values are:

```
[snetaid-config]
pidfile=/run/snetaid/snetaid.pid
loglevel=debug
foreground=0
logfile=/run/snetaid/snetaid.log
socket=/tmp/snetaid-socket
nl_monitor=/tmp/snetaid1000/rt_netlink.log
```

The pid file stores the process ID of the running daemon, and the standard syslog 
is used as the message logging so far. If you only need to see the logs generated by 
snetaid, you can use pipe and grep command to add display filter like this:

```bash
tail -f /var/log/syslog | grep "snetaid"
```

The pid file also locks the resource in order to prevent other instances of the program running, 
playing at the same time the role of a lock file.

### Building your own packages

You can build your own debian packages in a very easy way using `git-buildpackage` (a wrapper for `dpkg-buildpackage`). 
All you need to do is:

```sh
$ git clone https://git.devuan.org/aitor_czr/snetaid.git
$ cd snetaid
```

If you type `git status` you can see all:

```sh
On branch master
Your branch is up-to-date with 'origin/master'.
nothing to commit, working directory clean
```

To list all the local and remote branches type:

```sh
$ git branch -a
```

Let's checkout on the following branches (in this order):

```sh
$ git checkout -b pristine-tar origin/pristine-tar
$ git checkout -b gbp-release_0.1 origin/gbp-release_0.1
```

The prefix `gbp` reflects those branches containing the debian folder. 
Now we can build the packages:

```sh
$ gbp buildpackage
```

Once the packages have been generated, go to the build directory and install them:

```sh
$ cd ../build-area
$ sudo dpkg -i *.deb
```


## Building from source

If you are using a different package management system, then you'll need to build the project from source.

### Build dependencies

The current version of snetaid has been tested under Devuan Beowulf, requering:
- `gcc (4:8.3.0-1)`
- `cmake (3.13.4-1)`
- `libnetaid-dev (0.1-1)` 

libnetaid is available [here](https://git.devuan.org/aitor_czr/libnetaid).


### Procedure

Download the tarball from the git repository of devuan [snetaid](https://git.devuan.org/aitor_czr/snetaid/archive/master.tar.gz), 
extract it with `tar xvf master.tar.gz` and go into the extracted folder. There, run the 
following commands: 

```sh
$ mkdir build
$ cd build
$ cmake ..
$ make
$ sudo make install
```
> **Note**: By default, CMake does not provide the "make uninstall" target; so, in general, you cannot do this. 
However, snetaid adds an uninstall target to the CMAKE generated Makefile, in such a way that you can run:

```sh
$ sudo make uninstall
```
 
If the library in `/usr/local/lib` is not found (this is the destination when building from source), what you need to do is to tell 
the runtime loader to also look in this directory for libraries. There are two ways for that:

- The first way is to add the path to the `LD_LIBRARY_PATH` environment variable:

```sh
      export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/usr/local/lib"
```

- The second way is to update the configuration file of the runtime linker. This can happen either in the `/etc/ld.so.conf` file, by 
putting the line `/usr/local/lib` somewhere in that file, or by creating a new *.conf file in the `/etc/ld.so.conf.d/` directory that 
contains the new path. For example `/etc/ld.so.conf.d/99local.conf` with just `/usr/local/lib` in it. This is the recommended way of 
doing this, as it allows you to keep your custom library paths separate from paths set by the system. The "99" prefix is there to 
make sure the file is loaded last compared to other files there, so that it won't preempt system paths that could contain the same 
libraries (read [here](https://stackoverflow.com/questions/17889799/libraries-in-usr-local-lib-not-found)). After you modify/create 
the file in `/etc`, you need to update the `/etc/ld.so.cache` file:

```sh
      $ sudo ldconfig
```


## Usage

You can test snetaid running the binary from the command line:

```bash
/usr/sbin/snetaid
```

But this way does not run the daemon. Let's have a look at the command line 
parameters and arguments:

```bash
snetaid -- Simple Netaid Daemon

Usage: snetaid [options]

Options:
   -a --conf_file filename   Read configuration from the file
   -l --log_file  filename   Write logs to the file
   -p --pid_file  filename   PID file used by daemonized app
   -b --background           Run in the background
   -f --foreground           Run in the foreground (Default)
   -s --stop                 Stop the service once the connection has been stablished
   -h --help                 Show this help
   -k --kill                 Kill a running daemon
   -c --check-running        Check if a daemon is currently running
```

When `-b` option is append, it will become real UNIX daemon. However, this 
is not the way how UNIX daemons are started nowdays. Some init scripts 
or service files must be used for this purpose. 

For instance, if you are using sysvinit as init system, then you should be able 
to control the daemon via:

```bash
    service snetaid start
    service snetaid status
    service snetaid reload
    service snetaid stop
```
    
The third command reloads the configuration file restarting the daemon afterwards.


## Wireless connection

snetaid detects whether the ethernet cable has been plugged in, in which case it will 
try to connect to the wired device in the first place. In order to carry out a wireless 
connection attempt you need to install some available active wifi in "/etc/network/wifi" 
by using the wpa_passphrase command as follows:

```bash
wpa_passphrase ESSID PASSWORD > /etc/network/wifi/<some_descriptive_name_for_the_wifi>
```

The daemon will do the rest.


## Contributing

Pull requests are welcome. For major changes, please open an issue first to discuss what 
you would like to change.

Please make sure to update tests as appropriate.


## License

snetaid is free software: you can redistribute it and/or modify it under the terms of the 
GNU General Public License as published by the Free Software Foundation, either version 3 
of the License, or (at your option) any later version.

snetaid is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU 
General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. 
If not, see <http://www.gnu.org/licenses/>.

See the COPYING file.
