 /*
  * helpers.c
  * Copyright (C) Aitor Cuadrado Zubizarreta <aitor@genuen.org>
  * 
  * simple-netaid is free software: you can redistribute it and/or modify it
  * under the terms of the GNU General Public License as published by the
  * Free Software Foundation, either version 3 of the License, or
  * (at your option) any later version.
  * 
  * simple-netaid is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.
  * 
  * You should have received a copy of the GNU General Public License along
  * with this program.  If not, see <http://www.gnu.org/licenses/>.
  * 
  * See the COPYING file.
  */

#ifndef _GNU_SOURCE
   #define _GNU_SOURCE 1
#endif

// #include <sys/wait.h>
#include <sys/stat.h>
#include <assert.h>
#include <pstat/libpstat.h>

#include "def.h"
#include "helpers.h"
#include "sbuf.h"
#include "interfaces.h"
#include "ipaddr.h"
#include "wireless.h"

#define MAX_SIZE 128

void print_active_wifis(const char *wireless_device)
{
    sbuf_t s;
    sbuf_init(&s);   
    scan_active_wifis(wireless_device, &s);
    printf("%s\n", s.buf);
    sbuf_free(&s);
}

short ifquery(const char *ifname)
{
    FILE *fp;
    short state;
    sbuf_t cmd;
      
    sbuf_init(&cmd);
    if (access("/sbin/ifquery", F_OK) == 0) {	
        sbuf_concat(&cmd, 2, "/sbin/ifquery --state ", ifname);
    } else if (access("/usr/sbin/ifquery", F_OK) == 0) {	
        sbuf_concat(&cmd, 2, "/usr/sbin/ifquery --state ", ifname);
    } else {
	    printf(_("Cannot find ifquery\n"));
	    exit( EXIT_FAILURE );
	}	
         
    fp = popen(cmd.buf, "r");
    if (!fp) {
        state=-1;
        goto Free;
    }
   
    state=0;
    if (fgetc(fp)!=EOF)
        state=1;
   
    pclose(fp);
   
Free:
    sbuf_free(&cmd);
   
    return state;
}

void kill_all_processes()
{
	DIR *dirp = NULL;
	struct dirent *dir = NULL;
    const char *processes[] = { "dhclient", "dhcpcd", "udhcpc",
                                "pump", "dhcp6c", "wpa_supplicant", (char *)0 };
	
	dirp = opendir("/proc");
	if (!dirp) {
		printf("\n\tERROR: unable to open /proc for read\n\n");
		exit(EXIT_FAILURE);
	}
	
	while ((dir = readdir(dirp)) != NULL ) {

        int rc = 0;
	    struct stat sb;
        char *proc_cmd = NULL;
        bool is_uint_ok = true;
        char pth[MAX_SIZE] = {0};
	    
	    for (unsigned i=0; i < strlen(dir->d_name); i++)
            if (!isdigit(dir->d_name[i]))
                is_uint_ok = false;
      
        if (!is_uint_ok || !strcmp(dir->d_name, "1"))
            continue;
      
        strlcpy(pth, "/proc/", sizeof(pth));
        strcat(pth, dir->d_name);
        if (stat(pth, &sb) == -1) {
           perror("stat");
           continue;
        }
        
        if (!lstat(dir->d_name, &sb))
            continue;
 
        /* Only consider directories */
        if (!S_ISDIR(sb.st_mode))
            continue;

		rc = pstat_get_binary_path_from_string(&proc_cmd, MAX_SIZE, dir->d_name);
		if (rc)
            continue; 
        
        if (proc_cmd) {
            for (unsigned int i = 0; i < sizeof(processes)/sizeof(char*) - 1; i++) {
                if (!strcmp(rindex(proc_cmd, '/') + 1, processes[i])) {
                    if ((kill(atoi(dir->d_name), SIGTERM)) != 0)
                        kill(atoi(dir->d_name), SIGKILL);
                }
            }

            free(proc_cmd);
        }
	}
	
    closedir(dirp);
}
